clear all

* Set folder

cd ..\Inputs

* Import Monetary shocks data

use MONSHO, clear

* Import OECD data

merge 1:1 ISO year semester using OECD_quarterly
drop _merge
merge 1:1 ISO year semester using OECD_industrialprod
drop _merge
merge m:1 ISO year          using OECD_multifactor
drop _merge

* Import Oil data

merge m:1 year ISO      using OIL_sufficiency
drop _merge
merge m:1 year ISO      using OIL_intensity
drop _merge
merge m:1 year semester using OIL_prices
drop _merge
merge m:1 year semester using OIL_economou
drop _merge
merge m:1 year semester using OIL_ksemiannual
drop _merge

* Import EUKLEMS productivity data

merge m:1 year ISO using EUKLEMS_productivity
drop _merge

* Import WB deposit data

merge m:1 year ISO using WB_depositdata
drop _merge

* Import WEO data and AG fiscal shocks

merge m:1 year ISO using WEO_latestannual
drop _merge
merge 1:1 ISO year semester using AG_fiscalshocks
drop _merge

* Drop blanks and fill Country

drop if ISO==""
drop if ISO=="."
drop if semester==.
replace Country="Cyprus"          if ISO=="CYP"
replace Country="Malta"           if ISO=="MLT"
replace Country="Slovenia"        if ISO=="SVN"
replace Country="Czech Reoublic"  if ISO=="CZE"

* Order and sort

order ISO Country year semester
sort  ISO year semester

* Set panel structure

egen x=group(ISO)
by ISO: gen tt=_n
xtset x tt

* Construct innovations in the stuctural balance

gen L_GGSB=l.GGSB
gen L2_GGSB=l2.GGSB
reghdfe GGSB, absorb(x x#c.L2_GGSB  x#c.L_GGSB tt) residuals(sGGSB)
drop L*_GGSB

* Generate oil shocks that vary by country by interacting OILIM and OILSU 
* (which vary by country but are at the yearly frequency) with oil prices or 
* shocks (that don't vary by country but are at the semester frequency)

* Oil supply shock from Kilian (AER 2009)
* OILIM and OILSU lagged by one period

gen OILS1=l.OILIM*OILK
gen OILS2=(1-l.OILSU)*OILK

* Oil supply shock is the change in the price of oil
* OILIM and OILSU lagged by one period

gen OILS3=l.OILIM*(log(OILPR)-log(l.OILPR))
gen OILS4=(1-l.OILSU)*(log(OILPR)-log(l.OILPR))

* Oil supply shock is a residualized and normalized version of Economou (2016)
* OILIM and OILSU lagged by one period

gen OILS5=l.OILIM*NEXOILEC
gen OILS6=(1-l.OILSU)*NEXOILEC

* Oil supply shock from Baumeister and Hamilton (2015)
* OILIM and OILSU lagged by one period

gen OILS7=l.OILIM*OILBH
gen OILS8=(1-l.OILSU)*OILBH

* Construct productivity shock by purifying LPO by making it a residual 
* from an AR

reg LPO l(1/2).LPO, robust
predict PROD1 if e(sample), res

* Something weird is going on with Ireland in 2015 in these regressions though,
* so we should try to control for this

gen ireland2015=0
replace ireland2015=1 if ISO=="IRL" & year==2015 & semester==1
xtreg LPO l(1/2).LPO ireland2015 i.tt, fe
predict PROD2, e

* Allow AR(2) coefficients to vary across countries

gen L_LPO=l.LPO
gen L2_LPO=l2.LPO
reghdfe LPO ireland2015, absorb(x x#c.L_LPO x#c.L2_LPO tt) residuals(PROD3)
drop ireland2015 L*_LPO

* Label variables

* Identifier variables

label var ISO      "ISO country code"
label var Country  "Country name"
label var year     "Calendar year"
label var semester "Calendar semester"
label var x        "Country indicator for panel"
label var tt       "Time period indicator for panel"

* Monetary Variables

label var MONSHECB1 "Monetary shock for Europe, marginal lending facility"
label var MONSHECB2 "Monetary shock for Europe, deposit facility"
label var MONSH1 "Monetary shock 1 constructed from SVAR, semester"
label var MONSH2 "Monetary shock 2 constructed from SVAR, semester"
label var MONSH3 "Monetary shock 3 constructed from SVAR, semester"
label var MONSH4 "Monetary shock 4 constructed from SVAR, semester"
label var MONSH5 "Monetary shock 5 constructed from SVAR, semester"
label var INTERE "Interest rates, different indicators, IMF IFS, semester"
label var INFLAT "Inflation, IMF IFS, semester"
label var GROWTH "Growth, IMF IFS, semester"
label var UNEMPL "Unemployment rate, IMF IFS, semester"
label var STOCKM "Stock market, IMF IFS, semester"

* Variables coming from OECD data:

label var CPILVL "Consumer price index, OECD, semester"
label var CPIHAR "Consumer price index, Harmonized, OECD, semester"
label var CPIGRO "Consumer price index, growth in %, OECD, semester"
label var CONLVL "Consumption level, OECD, semester"
label var CONGRO "Consumption growth, OECD, semester"
label var GOV    "General government employment, OECD, semester"
label var TEM    "Total employment, OECD, semester"
label var GD4    "GDP, value, market prices, OECD, semester"
label var GD1    "GDP, volume, market prices, OECD, semester"
label var GDPGRO "Real GDP growth in %, OECD, semester"
label var GD2    "GDP, in dollars, volume, con exchange rates, OECD, semester"
label var GD3    "GDP, in dollars, current prices, con ex rate, OECD, semester"
label var HWO    "Hours worked per employee, OECD, semester"
label var LTI    "Long term interest rate on gov bonds, OECD, semester"
label var STI    "Short term interest rate, OECD, semester"
label var INVLVL "Investment level, OECD, semester"
label var INVGRO "Investment growth, OECD, semester"
label var LFO    "Labor force, OECD, semester"
label var LPO    "Labor productivity, OECD, semester"
label var GDD    "GDP deflator, market prices, OECD, semester"
label var UNR    "Unemployment rate, OECD, semester"
label var IPL    "Industrial Production, level, 2010=100, OECD, semester"
label var MFPGRO "Multifactor productivity from OECD, growth rate"
label var MFPLVL "Multifactor productivity from OECD, level"

* Variables related to Oil:

label var OILSU "Oil sufficiency indicator, OECD, annual"
label var OILIM "Oil imports indicator, OECD, annual"
label var OILPR "Oil price, FRED, semester"
label var OILK  "Oil Shock from Kilian (2009)"
label var OILBH "Oil Shock from Baumeister and Hamilton(2015)"
drop      roilp

* TFP from EUKLEMS:

label var TFP12EUK "TFP, EUKLEMS, 2012 release, 2005=100"
label var TFP16EUK "TFP, EUKLEMS, 2016 release, renormalized to have 2005=100"
label var TFPEUK   "TFP, EUKLEMS combining 2012/2016 releases"

* Deposit and banking variables from World Bank

label var BADEPtGDP "Bank deposits to GDP (%)"
label var BACRIDUMM "Banking crisis dummy (1=banking crisis, 0=none)"
label var BAASStGDP "Deposit money banks' assets to GDP (%)"
label var FNSYAtGDP "Financial system deposits to GDP (%)"
label var PROVINPLO "Provisions to nonperforming loans (%)"

* Variables coming from latest IMF WEO at an annual frequency:

label var GGSB  "General government structural balance, IMF WEO, annual"
label var sGGSB "(Residualized) General government structural balance, IMF WEO, annual"
label var EMPL  "Employment, IMF WEO, annual"
label var UNRA  "Unemployment rate, IMF WEO, annual"
label var NGAP  "Output gap in percent of potential GDP, IMF WEO, annual"
label var GDPL  "GDP current prices local currency units, IMF WEO, annual"
label var GDPD  "GDP current prices in dollars, IMF WEO, annual"
label var GDDE  "GDP deflator, IMF WEO, annual"
label var GDCP  "GDP constant prices local currency units, IMF WEO, annual"
label var GNSA  "Gross national savings, IMF WEO, annual"
label var TINV  "Total investment, IMF WEO, annual"
label var PCPI  "Inflation, average consumer prices, IMF WEO, annual"

* Fiscal shocks taken from AG

order FE0, b(FE1)
label var FE0 "Fiscal shock variable taken from AG"
* Is AG's L0_FE = current value of the unanticipated government spending shock
label var FE1 "Second fiscal shock taken from AG"
* This is like FE0 but further purified by regressing it on lags of the third
* release of actual data and location fixed effects
label var FE2 "Third fiscal shock taken from AG"
* This is like FE1 but further purified by regressing it on more things
label var FE3 "Fourth fiscal shock taken from AG"
* This is like FE2 but further purified by regressing it on even more things

* Constructed oil shocks

label var OILS1 "Oil shock from interaction bet OILIM and OILK, semester"
label var OILS2 "Oil shock from interaction bet OILSU and OILK, semester"
label var OILS3 "Oil shock, interaction bet OILIM and D.log(OILPR), semester"
label var OILS4 "Oil shock, interaction bet OILSU and D.log(OILPR), semester"
label var OILS5 "Oil sh, interaction bet OILIM and Economou's shock, semester"
label var OILS6 "Oil sh, interaction bet OILSU and Economou's shock, semester"
label var OILS7 "Oil shock from interaction bet OILIM and OILBH, semester"
label var OILS8 "Oil shock from interaction bet OILSU and OILBH, semester"

* Constructed productivity shocks

label var PROD1 "Productivity shock constructed from LPO via AR(2)"
label var PROD2 "Productivity shock constructed from LPO via AR(2) with time and country fixed effects"
label var PROD3 "Like PROD2 but also controling for Ireland's weird observation"

* Change to output folder and save database

cd ..\Outputs
save SHOCKS, replace
